#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------
# Setup for CPRS communication
#---------------------------------------------------------------------

from OSEHRAHelper import PROMPT

def SetupCPRS(VistA):
  VistA.wait(PROMPT)
  VistA.write('S DUZ=1 D Q^DI')
  VistA.wait('Select OPTION:')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('14.5\r')
  VistA.wait('Select VOLUME SET')
  VistA.write('`1')
  VistA.wait('VOLUME SET:')
  VistA.write('ROU\r\r\r\r\r')
  VistA.wait('TASKMAN FILES UCI')
  if VistA.type=='cache':
    VistA.write('CPM\r\r\r\r\r\r')
  else:
    VistA.write('ROU\r\r\r\r\r\r')

  VistA.wait('Select OPTION:')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('14.7')
  VistA.wait('ALL//')
  VistA.write('')
  VistA.wait('Select TASKMAN SITE PARAMETERS BOX-VOLUME PAIR:')
  VistA.write('`1')
  VistA.wait('//')
  VistA.write(VistA.boxvol)
  VistA.wait('RESERVED')
  VistA.write('^\r')

  VistA.wait('Select OPTION')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('8994.1\r')
  VistA.wait('Select RPC BROKER SITE PARAMETERS DOMAIN NAME')
  VistA.write('DEMO.OSEHRA.ORG\r\r\r\r' + VistA.boxvol + '\rY\r\r9210\rY')
  if VistA.type=='cache':
    VistA.write('1\r\r1\r')
  else:
    VistA.write('1\r\r\r')

  VistA.wait('Select OPTION')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('KERNEL SYSTEM PARAMETERS\rVOLUME SET\r\r')
  VistA.wait('Select KERNEL SYSTEM PARAMETERS DOMAIN NAME:')
  VistA.write('DEMO.OSEHRA.ORG\r\rROU\rY\r500\rN\r\r\r')

  if VistA.type=='cache':
    VistA.write('S DUZ=1 D ^XUP')
    VistA.wait('OPTION NAME')
    VistA.write('EVE\r1')
    VistA.wait('Option')
    VistA.write('TASK')
    VistA.wait('Option:')
    VistA.write('SCHED')
    VistA.wait('reschedule:')
    VistA.write('XWB LISTENER STARTER\rY')
    VistA.wait('COMMAND:')
    VistA.write('\r^SPECIAL QUEUEING\rSTARTUP\rS\rE\r\r\r\r')
